<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\client;
use App\Models\file;
use App\Models\lawyer;
use App\Models\court;
use App\Models\job;
use App\Models\session;


class DashboardController extends Controller
{
    public function indexAdmin () {

        $files =  file::orderBy('created_at', 'desc')->limit(5)->get();
        $clients =  client::All();
        $jobs =  job::orderBy('created_at', 'desc')->limit(10)->get();
        $lawyers =  lawyer::All();
        $courts =  court::All();
        $user = auth()->user();

        // إذا كان المستخدم لديه دور Admin، اجلب جميع الجلسات
        if ($user->hasRole('Admin')) {
            $sessions =  session::orderBy('created_at', 'desc')->limit(5)->get();
        } else {
            // جلب القضايا المسموح للمستخدم برؤيتها
            $allowedCaseIds = $user->permissions->pluck('name')->map(function ($permission) {
                return str_replace('ارقام القضايا', '', $permission);
            })->toArray();

            // جلب الجلسات التي تنتمي إلى القضايا المسموح بها
            $sessions = session::whereIn('file_id', $allowedCaseIds)->orderBy('created_at', 'desc')->get();
        }


        // إذا كان المستخدم لديه دور Admin، اجلب جميع الجلسات
          // تحميل الجلسات مع العلاقات المطلوبة
          if ($user->hasRole('Admin')) {
            $jobs = job::with(['lawyers', 'clients', 'files', 'courts']) // تحميل العلاقات
                       ->orderBy('created_at', 'desc')
                       ->get();
        } else {
            // جلب القضايا المسموح للمستخدم برؤيتها
            $allowedCaseIds = $user->permissions->pluck('name')->map(function ($permission) {
                return str_replace('ارقام القضايا', '', $permission);
            })->toArray();

            // جلب الجلسات مع العلاقات المطلوبة
            $jobs = job::with(['lawyers', 'clients', 'files', 'courts'])
                       ->whereIn('file_id', $allowedCaseIds)
                       ->orderBy('created_at', 'desc')
                       ->get();
        }

        return view('admin.dashboard', compact('clients', 'files', 'jobs', 'lawyers', 'courts', 'sessions'));

    }
}
