<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Admin;
use App\Models\file;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;
use DB;
use Hash;

class userController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:المستخدمين', ['only' => ['index', 'store']]);
        $this->middleware('permission:المستخدمين', ['only' => ['create', 'store']]);
        $this->middleware('permission:المستخدمين', ['only' => ['editUser', 'update']]);
        $this->middleware('permission:المستخدمين', ['only' => ['delete']]);
    }

    public function index(Request $request)
    {
        // عرض قائمة المسؤولين من جدول admins
        $data = Admin::orderBy('id', 'DESC')->paginate(5);
        $roles = Role::all();  // بدلاً من pluck

        return view('admin.users.index', compact('data', 'roles'))
            ->with('i', ($request->input('page', 1) - 1) * 5);
    }


    public function store(Request $request)
    {
        // التحقق من صحة المدخلات
        $this->validate($request, [
            'email' => 'required|email|unique:admins,email',
            'password' => 'required|same:confirm-password',
            'getRoleNames' => 'required'
        ]);

        $input = $request->all();
        $input['password'] = Hash::make($input['password']);

        // إضافة مسؤول جديد إلى جدول admins
        $admin = Admin::create($input);

        // تعيين الدور للمسؤول
        $admin->assignRole($request->input('getRoleNames'));

        return redirect()->back()->with(['successAdd' => '']);
    }

    public function editUser($admin_id)
    {
        // عرض نموذج تعديل مسؤول
        $admin = Admin::find($admin_id);
        if (!$admin) {
            return redirect()->back();
        }

        $roles = Role::all();  // بدلاً من pluck
        $adminRole = $admin->roles->pluck('name', 'name')->all();

        return view('admin.users.edit', compact('admin', 'roles', 'adminRole'));
    }


    public function updateUser(Request $request, $id)
    {
        // التحقق من صحة المدخلات
        $this->validate($request, [
            'email' => 'required|email|unique:admins,email,' . $id,
            'getRoleNames' => 'required'
        ]);

        $input = $request->all();
        $admin = Admin::find($id); // استخدام Admin بدلاً من User
        $admin->update($input);

        // حذف الأدوار القديمة وتعيين الأدوار الجديدة
        DB::table('model_has_roles')->where('model_id', $id)->delete();
        $admin->assignRole($request->input('getRoleNames'));

        return redirect()->back()->with(['successEdit' => ' تم التحديث بنجاح ']);
    }



    public function editUserPass($admin_id)
    {
        // عرض نموذج تعديل مسؤول
        $admin = Admin::find($admin_id);
        if (!$admin) {
            return redirect()->back();
        }

        $roles = Role::all();  // بدلاً من pluck
        $adminRole = $admin->roles->pluck('name', 'name')->all();

        return view('admin.users.editPass', compact('admin', 'roles', 'adminRole'));
    }




    public function updateUserPass(Request $request, $id)
    {
        $this->validate($request, [
            'email' => 'email|unique:admins,email,' . $id,
        ]);

        $input = $request->all();
        $admin = Admin::find($id); // استخدام Admin بدلاً من User
        $admin->update([

            'password' => Hash::make($request->password),

        ]);

        return redirect()->back()->with(['successEdit' => ' تم التحديث بنجاح ']);
    }



    public function deleteUser($admin_id)
    {
        // حذف المسؤول من جدول admins
        $admin = Admin::find($admin_id);
        if (!$admin) {
            return redirect()->back()->with(['error' => 'Admin not found']);
        }

        $admin->delete();

            return redirect()->back()->with(['successDelete' => ' تم الحذف بنجاح ']);
    }





    public function assignCases($id)
    {
        $admin = admin::findOrFail($id);
        $files = file::all(); // جلب جميع القضايا

        // جلب الصلاحيات الممنوحة للمستخدم
        $assignedCases = $admin->permissions->pluck('name')->toArray();

        return view('admin.dashboard.assign_cases', compact('admin', 'files', 'assignedCases'));
    }



    public function storeAssignedCases(Request $request, $id)
    {
        $admin = admin::findOrFail($id);

        // أولاً، إلغاء جميع الصلاحيات الحالية المتعلقة بالقضايا
        $admin->revokePermissionTo($admin->permissions->pluck('name')->toArray());

        // إنشاء الصلاحيات ديناميكيًا وتعيينها للمستخدم
        if ($request->has('cases')) {
            foreach ($request->cases as $case) {
                // التحقق من إذا كانت الصلاحية موجودة، وإذا لم تكن، يتم إنشاؤها
                Permission::firstOrCreate(['name' => $case]);

                // تعيين الصلاحية للمستخدم
                $admin->givePermissionTo($case);
            }
        }

        return redirect()->back()->with(['successAdd' => ' تم التحديث بنجاح ']);
    }




}
