<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\aboutUsRequest;
use App\Http\Requests\companyFieldsRequest;
use App\Models\about;
use LaravelLocalization;
use App\Traits\allTraits;


class aboutUsController extends Controller
{
    use allTraits;

    public function addAboutUs() {

        $abouts =  about::All();
        return view('admin.addAboutUs', compact('abouts'));
    }


    public function aboutPost(aboutUsRequest $request)
    {

        about::create([
            'details_ar' => $request -> details_ar,
            'details_en' => $request -> details_en,
        ]);

        return redirect()->back()->with(['successAdd' => '']);

    }


    public function allAboutUs() {

        $abouts =  about::All();
        return view('admin.allAboutUs', compact('abouts'));
    }


    public function deleteAboutUs($abouts_id)
    {

        $abouts = about::find($abouts_id);

        if (!$abouts)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $abouts->delete();

        return redirect()
            ->route('aboutUs')
            ->with(['successDelete' => __('messages.news deleted successfully')]);

    }


    public function editAboutUs($abouts_id)
    {

        // addNews::findOrFail($news_id);
        $abouts = about::find($abouts_id);  // search in given table id only
        if (!$abouts)
            return redirect()->back();

        $abouts = about::all()->find($abouts_id);
        return view('admin.editAboutUs', compact('abouts'));


    }


    public function UpdateAboutUs(aboutUsRequest $request, $abouts_id)
    {

        $about = about::find($abouts_id);
        if (!$about)
            return redirect()->back();

        //update data

        $about->update([
            'details_ar' => $request -> details_ar,
            'details_en' => $request -> details_en,
        ]);

        return redirect()->back()->with(['successEdit' => ' تم التحديث بنجاح ']);

    }







}
