<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\caseTypeRequest;
use Illuminate\Support\Facades\Hash;
use App\Models\attribute;
use App\Models\case_type;
use LaravelLocalization;
use App\Traits\allTraits;


class caseTypeController extends Controller
{
    use allTraits;



    public function caseTypePost(caseTypeRequest $request)
    {


        case_type::create([
            'title' => $request -> title,
        ]);



        return redirect()->back()->with(['successAdd' => '']);
    }


    public function AllCaseType() {
        $case_types =  case_type::All();
        return view('admin.dashboard.caseType', compact('case_types'));
    }


    public function deleteCaseType($case_types_id)
    {

        $case_types = case_type::find($case_types_id);

        if (!$case_types)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $case_types->delete();

        return redirect()
            ->route('AllCaseType')
            ->with(['successDelete' => __('messages.news deleted successfully')]);
    }







    public function editCase_type($case_types_id)
    {

        $case_types = case_type::find($case_types_id);  // search in given table id only
        if (!$case_types)
            return redirect()->back();
        $case_types = case_type::all()->find($case_types_id);
        return view('admin.dashboard.editCaseType', compact('case_types'));

    }



    public function UpdateCase_type(caseTypeRequest $request, $case_types_id)
    {

        $case_type = case_type::find($case_types_id);
        if (!$case_type)
            return redirect()->back();



        $case_type->update([
            'title' => $request -> title,

        ]);

        return redirect()->back()->with(['successEdit' => ' تم التحديث بنجاح ']);

    }



}
