<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\clientRequest;
use Illuminate\Support\Facades\Hash;
use App\Models\client;
use App\Models\file;
use App\Models\document;
use LaravelLocalization;
use App\Traits\allTraits;
use Illuminate\Database\Eloquent\SoftDeletes;


class clientsController extends Controller
{
    use allTraits;



    public function clientPost(clientRequest $request)
    {


        client::create([
            'name' => $request -> name,
            'code' => $request -> code,
            'password' => Hash::make($request->password),
            'address' => $request -> address,
            'phone' => $request -> phone,
        ]);



        return redirect()->back()->with(['successAdd' => '']);
    }


    public function AllClients() {
        $clients =  client::orderBy('created_at', 'desc')->get();
        return view('admin.dashboard.clients', compact('clients'));
    }


    public function archiveClients($clients_id)
    {

        $clients = client::find($clients_id);

        if (!$clients)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $clients->delete();

        return redirect()
            ->route('AllClients')
            ->with(['successArchive' => __('messages.news deleted successfully')]);
    }


    public function clientsTrashed()
    {
        $clients = client::onlyTrashed()->get();
        return view('admin.dashboard.clientsArchive',compact('clients'));
    }





    public function DeleteClient($clients_id)
    {

        client::where('id', $clients_id)->withTrashed()->forceDelete();
        return redirect()->back()

        ->with(['successDelete' => __('messages.news deleted successfully')]);

    }





    public function editClients($clients_id)
    {

        $clients = client::find($clients_id);  // search in given table id only
        if (!$clients)
            return redirect()->back();
        $clients = client::all()->find($clients_id);
        return view('admin.dashboard.editClients', compact('clients'));

    }



    public function UpdateClients(clientRequest $request, $clients_id)
    {

        $client = client::find($clients_id);
        if (!$client)
            return redirect()->back();

        //update data


        $client->update([
            'name' => $request -> name,
            'code' => $request -> code,
            'password' => Hash::make($request->password),
            'address' => $request -> address,
            'phone' => $request -> phone,
        ]);

        return redirect()->back()->with(['successEdit' => ' تم التحديث بنجاح ']);

    }






    public function changePassClient($clients_id)
    {

        $clients = client::find($clients_id);  // search in given table id only
        if (!$clients)
            return redirect()->back();
        $clients = client::all()->find($clients_id);
        return view('admin.dashboard.changePassClient', compact('clients'));

    }



    public function UpdatePassClient(clientRequest $request, $clients_id)
    {

        $client = client::find($clients_id);
        if (!$client)
            return redirect()->back();

        //update data


        $client->update([
            'password' => Hash::make($request->password),
        ]);

        return redirect()->back()->with(['successEdit' => ' تم التحديث بنجاح ']);

    }







    public function clientDetails($clients_id)
    
    {
        $client = Client::with('files.sessions', 'files.documents', 'files.bailiffs', 'files.experts', 'files.disputes', 'files.family_disputes')->find($clients_id);

        if (!$client) {
            return redirect()->back()->with('error', 'الموكل غير موجود');
        }
        
          $files = file::all()->find($clients_id);

        $clients = client::all()->find($clients_id);

        return view('admin.dashboard.clientDetails', compact('client', 'clients'));
    }

}
