<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\companyRequest;
use Illuminate\Support\Facades\Hash;
use App\Models\company;
use App\Models\file;
use App\Models\document;
use LaravelLocalization;
use App\Traits\allTraits;
use Illuminate\Database\Eloquent\SoftDeletes;


class companyController extends Controller
{
    use allTraits;



    public function companyPost(companyRequest $request)
    {


        company::create([
            'name' => $request -> name,
            'code' => $request -> code,
            'password' => Hash::make($request->password),
            'address' => $request -> address,
            'phone' => $request -> phone,
        ]);



        return redirect()->back()->with(['successAdd' => '']);
    }


    public function AllCompanies() {
        $companies =  company::orderBy('created_at', 'desc')->get();
        return view('admin.dashboard.companies', compact('companies'));
    }


    public function archiveCompanies($companies_id)
    {

        $companies = company::find($companies_id);

        if (!$companies)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $companies->delete();

        return redirect()
            ->route('AllCompanies')
            ->with(['successArchive' => __('messages.news deleted successfully')]);
    }


    public function companiesTrashed()
    {
        $companies = company::onlyTrashed()->get();
        return view('admin.dashboard.companiesArchive',compact('companies'));
    }





    public function deleteCompany($companies_id)
    {

        company::where('id', $companies_id)->withTrashed()->forceDelete();
        return redirect()->back()

        ->with(['successDelete' => __('messages.news deleted successfully')]);

    }





    public function editCompanies($companies_id)
    {

        $companies = company::find($companies_id);  // search in given table id only
        if (!$companies)
            return redirect()->back();
        $companies = company::all()->find($companies_id);
        return view('admin.dashboard.editCompanies', compact('companies'));

    }



    public function UpdateCompanies(companyRequest $request, $companies_id)
    {

        $company = company::find($companies_id);
        if (!$company)
            return redirect()->back();

        //update data


        $company->update([
            'name' => $request -> name,
            'code' => $request -> code,
            'password' => Hash::make($request->password),
            'address' => $request -> address,
            'phone' => $request -> phone,
        ]);

        return redirect()->back()->with(['successEdit' => ' تم التحديث بنجاح ']);

    }






    public function changePassCompany($companies_id)
    {

        $companies = company::find($companies_id);  // search in given table id only
        if (!$companies)
            return redirect()->back();
        $companies = company::all()->find($companies_id);
        return view('admin.dashboard.changePassCompany', compact('companies'));

    }



    public function UpdatePasscompany(companyRequest $request, $companies_id)
    {

        $company = company::find($companies_id);
        if (!$company)
            return redirect()->back();

        //update data


        $company->update([
            'password' => Hash::make($request->password),
        ]);

        return redirect()->back()->with(['successEdit' => ' تم التحديث بنجاح ']);

    }







    public function companyDetails($companies_id)

    {
        $company = company::with('files.sessions', 'files.documents', 'files.bailiffs', 'files.experts', 'files.disputes', 'files.family_disputes')->find($companies_id);

        if (!$company) {
            return redirect()->back()->with('error', 'الشركة غير موجودة');
        }

          $files = file::all()->find($companies_id);

        $companies = company::all()->find($companies_id);

        return view('admin.dashboard.companyDetails', compact('company', 'companies'));
    }

}
