<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\phoneRequest;
use App\Http\Requests\emailRequest;
use App\Http\Requests\AddressesRequest;
use App\Models\phone;
use App\Models\email;
use App\Models\Address;
use LaravelLocalization;


class contactUsController extends Controller
{

    public function allPhones() {

        $phones =  phone::All();
        return view('admin.allPhones', compact('phones'));
    }


    public function phonePost(phoneRequest $request)
    {

        phone::create([
            'type' => $request -> type,
            'number' => $request -> number,

        ]);

        return redirect()->back()->with(['successAdd' => '']);

    }



    public function deletePhone($phones_id)
    {

        $phones = phone::find($phones_id);

        if (!$phones)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $phones->delete();

        return redirect()
            ->route('allPhones')
            ->with(['successDelete' => __('messages.news deleted successfully')]);

    }





    /****** email *******/

    public function allEmails() {

        $emails =  email::All();
        return view('admin.allEmails', compact('emails'));
    }


    public function emailPost(emailRequest $request)
    {

        email::create([
            'email' => $request -> email,

        ]);

        return redirect()->back()->with(['successAdd' => '']);

    }



    public function deleteEmail($emails_id)
    {

        $emails = email::find($emails_id);

        if (!$emails)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $emails->delete();

        return redirect()
            ->route('allEmails')
            ->with(['successDelete' => __('messages.news deleted successfully')]);

    }




    /********** address ********/

    public function allAddresses() {

        $addresses =  Address::All();
        return view('admin.allAddresses', compact('addresses'));
    }


    public function AddressPost(AddressesRequest $request)
    {

        Address::create([
            'title_ar' => $request -> title_ar,
            'title_en' => $request -> title_en,

        ]);

        return redirect()->back()->with(['successAdd' => '']);

    }



    public function deleteAddress($Addresses_id)
    {

        $Addresses = Address::find($Addresses_id);

        if (!$Addresses)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $Addresses->delete();

        return redirect()
            ->route('allAddresses')
            ->with(['successDelete' => __('messages.news deleted successfully')]);

    }

}
