<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\filesRequest;
use App\Http\Requests\docRequest;
use App\Models\client;
use App\Models\file;
use App\Models\session;
use App\Models\court;
use App\Models\attribute;
use App\Models\documentation_office;
use App\Models\attach;
use App\Models\police;
use App\Models\document;
use App\Models\bailiff;
use App\Models\expert;
use App\Models\dispute;
use App\Models\litigation_degree;
use App\Models\case_type;
use App\Models\family_dispute;
use App\Models\lawyer;
use App\Models\User;
use App\Models\institution;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\JsonResponse;
use LaravelLocalization;
use App\Traits\allTraits;


class filesController extends Controller
{

    public function filePost(filesRequest $request)
    {
        $photo = array();
        if ($files = $request->file('photo')) {
            foreach ($files as $uploadedFile) { // تعديل التسمية من $file إلى $uploadedFile
                $photo_name = md5(rand(1000, 10000));
                $ext = strtolower($uploadedFile->getClientOriginalExtension()); // الحصول على الامتداد
                $photo_full_name = $photo_name . '.' . $ext;
                $upload_path = 'images/casefiles/';
                $photo_url = $upload_path . $photo_full_name;
                $uploadedFile->move($upload_path, $photo_full_name);
                $photo[] = $photo_url;
            }
        }

        // إنشاء القضية وتخزين بياناتها في قاعدة البيانات
        $newFile = file::create([
            'client_id' => $request->client_id,
            'lawyer_id' => $request->lawyer_id,
            'fileCaseNum' => $request->fileCaseNum,
            'attribute_id' => $request->attribute_id,
            'court_id' => $request->court_id,
            'requestingParty' => $request->requestingParty,
            'type' => $request->type,
            'police_id' => $request->police_id,
            'institution_id' => $request->institution_id,
            'documentation_office_id' => $request->documentation_office_id,
            'caseNum' => $request->caseNum,
            'fileNum' => $request->fileNum,
             'year' => $request->year,
            'litigation_degree_id' => $request -> litigation_degree_id,
            'photo' => implode('|', $photo),
            'opponentName' => $request->opponentName,
            'attorneyType' => $request->attorneyType,
            'opponentAddress' => $request->opponentAddress,
            'professorsLawyer' => $request->professorsLawyer,

            'ProceduresDone' => $request->ProceduresDone,
            'ProcedureDate' => $request->ProcedureDate,
            'personCharge' => $request->personCharge,
            'case_type_id' => $request -> case_type_id,
            'details' => $request->details,
        ]);

        // إنشاء اسم الصلاحية بناءً على رقم القضية الجديد
        $permissionName = 'view-case-' . $newFile->id;

        // إضافة الصلاحية الجديدة إذا لم تكن موجودة
        \Spatie\Permission\Models\Permission::firstOrCreate(['name' => $permissionName]);

        // منح الصلاحية لدور معين (مثل 'admin')
        $role = \Spatie\Permission\Models\Role::findByName('admin'); // تأكد من أن الدور موجود
        $role->givePermissionTo($permissionName);

        return redirect()->back()->with(['successAddFile' => 'تمت إضافة القضية بنجاح']);
    }



    public function addFiles() {

        $clients =  client::All();
        $lawyers =  lawyer::All();
        $attributes =  attribute::All();
        $courts =  court::All();
        $documentation_offices =  documentation_office::All();
        $polices =  police::All();
        $institutions =  institution::All();
        $case_types =  case_type::All();
        $user = auth()->user();
               // حذف الجلسات القديمة بشكل أوتوماتيك قبل العرض
        $oldSessions = Session::where('date', '<', date('Y-m-d'))->get();

        foreach ($oldSessions as $session) {
            $session->delete();  // نفس فكرتك في دالة archiveSessions
        }

        // بعدها نجيب الجلسات النشطة
        if ($user->hasRole('Admin')) {
            $sessions = Session::orderBy('created_at', 'desc')->get();
        } else {
            $allowedCaseIds = $user->permissions->pluck('name')->map(function ($permission) {
                return str_replace('ارقام القضايا', '', $permission);
            })->toArray();

            $sessions = Session::whereIn('file_id', $allowedCaseIds)
                               ->orderBy('created_at', 'desc')
                               ->get();
        }
                // إذا كان المستخدم لديه دور Admin، اجلب جميع الجلسات
        if ($user->hasRole('Admin')) {
            $documents = document::orderBy('created_at', 'desc')->get();
        } else {
            // جلب القضايا المسموح للمستخدم برؤيتها
            $allowedCaseIds = $user->permissions->pluck('name')->map(function ($permission) {
                return str_replace('ارقام القضايا', '', $permission);
            })->toArray();

            // جلب الجلسات التي تنتمي إلى القضايا المسموح بها
            $documents = document::whereIn('file_id', $allowedCaseIds)->orderBy('created_at', 'desc')->get();
        }



          $user = auth()->user();
        // إذا كان المستخدم لديه دور Admin، اجلب جميع الجلسات
        if ($user->hasRole('Admin')) {
            $bailiffs = bailiff::orderBy('created_at', 'desc')->get();
        } else {
            // جلب القضايا المسموح للمستخدم برؤيتها
            $allowedCaseIds = $user->permissions->pluck('name')->map(function ($permission) {
                return str_replace('ارقام القضايا', '', $permission);
            })->toArray();

            // جلب الجلسات التي تنتمي إلى القضايا المسموح بها
            $bailiffs = bailiff::whereIn('file_id', $allowedCaseIds)->orderBy('created_at', 'desc')->get();
        }



          $user = auth()->user();
        // إذا كان المستخدم لديه دور Admin، اجلب جميع الجلسات
        if ($user->hasRole('Admin')) {
            $experts = expert::orderBy('created_at', 'desc')->get();
        } else {
            // جلب القضايا المسموح للمستخدم برؤيتها
            $allowedCaseIds = $user->permissions->pluck('name')->map(function ($permission) {
                return str_replace('ارقام القضايا', '', $permission);
            })->toArray();

            // جلب الجلسات التي تنتمي إلى القضايا المسموح بها
            $experts = expert::whereIn('file_id', $allowedCaseIds)->orderBy('created_at', 'desc')->get();
        }


         $user = auth()->user();
        // إذا كان المستخدم لديه دور Admin، اجلب جميع الجلسات
        if ($user->hasRole('Admin')) {
            $disputes = dispute::orderBy('created_at', 'desc')->get();
        } else {
            // جلب القضايا المسموح للمستخدم برؤيتها
            $allowedCaseIds = $user->permissions->pluck('name')->map(function ($permission) {
                return str_replace('ارقام القضايا', '', $permission);
            })->toArray();

            // جلب الجلسات التي تنتمي إلى القضايا المسموح بها
            $disputes = dispute::whereIn('file_id', $allowedCaseIds)->orderBy('created_at', 'desc')->get();
        }


        $user = auth()->user();
        // إذا كان المستخدم لديه دور Admin، اجلب جميع الجلسات
        if ($user->hasRole('Admin')) {
            $family_disputes = family_dispute::orderBy('created_at', 'desc')->get();
        } else {
            // جلب القضايا المسموح للمستخدم برؤيتها
            $allowedCaseIds = $user->permissions->pluck('name')->map(function ($permission) {
                return str_replace('ارقام القضايا', '', $permission);
            })->toArray();

            // جلب الجلسات التي تنتمي إلى القضايا المسموح بها
            $family_disputes = family_dispute::whereIn('file_id', $allowedCaseIds)->orderBy('created_at', 'desc')->get();
        }


        $lawyers  = lawyer::All();
        $litigation_degrees =  litigation_degree::All();
        return view('admin.dashboard.addFiles', compact('clients', 'sessions', 'lawyers', 'institutions', 'documents', 'bailiffs', 'experts', 'disputes', 'family_disputes', 'attributes', 'courts', 'documentation_offices', 'polices', 'case_types', 'litigation_degrees'));
    }




    public function AllFiles() {
        $files =  file::orderBy('created_at', 'desc')->get();
        $clients =  client::All();
        $lawyers =  lawyer::All();
        $attributes =  attribute::All();
        $courts =  court::All();
        $documentation_offices =  documentation_office::All();
        $polices =  police::All();
        $institutions =  institution::All();
        $case_types =  case_type::All();
        $litigation_degrees =  litigation_degree::All();
        return view('admin.dashboard.files', compact('clients', 'files', 'attributes', 'courts', 'documentation_offices', 'polices', 'case_types', 'litigation_degrees'));
    }


    public function archiveFiles($files_id)
    {

        $files = file::find($files_id);

        if (!$files)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $files->delete();

        return redirect()
            ->route('AllFiles')
            ->with(['successArchive' => __('messages.news deleted successfully')]);
    }


    public function filesTrashed()
    {
        $files = file::onlyTrashed()->get();
        return view('admin.dashboard.filesArchive',compact('files'));
    }





    public function Deletefile($files_id)
    {

        file::where('id', $files_id)->withTrashed()->forceDelete();
        return redirect()->back()

        ->with(['successDeleteFile' => __('messages.news deleted successfully')]);

    }





public function editFiles(Request $request, $files_id)
{
    // استخدم `find()` لاسترجاع السجل الفردي
    $files = File::find($files_id);

    // تحقق من وجود السجل
    if (!$files) {
        return redirect()->back()->with('error', 'الملف غير موجود');
    }

    // استرجاع جميع المحاكم
    $courts = Court::all();

$documentation_offices =  documentation_office::All();
    // إرجاع البيانات إلى الـ view
    $polices =  police::All();
    $institutions =  institution::All();
     $litigation_degrees =  litigation_degree::All();
       $attributes =  attribute::All();
       $lawyers  = lawyer ::all();

    $case_types =  case_type::All();

       if ($request->hasFile('photo')) {
        $uploadedFiles = $request->file('photo');
        $newFiles = [];

        foreach ($uploadedFiles as $file) {
            $filename = time() . '_' . $file->getClientOriginalName();
            $file->move(public_path('uploads'), $filename);
            $newFiles[] = 'uploads/' . $filename;
        }

        // دمج الملفات الجديدة مع القديمة
        $allFiles = array_merge(explode('|', $files->photo), $newFiles);
        $files->photo = implode('|', $allFiles);
        $files->save();
    }

    // حذف الملفات
    if ($request->has('delete_file')) {
        $fileToDelete = $request->input('delete_file');
        if (in_array($fileToDelete, explode('|', $files->photo))) {
            $path = public_path($fileToDelete);
            if (file_exists($path)) {
                unlink($path);
            }

            // إزالة الملف من السلسلة
            $remainingFiles = array_filter(explode('|', $files->photo), function($file) use ($fileToDelete) {
                return $file !== $fileToDelete;
            });

            $files->photo = implode('|', $remainingFiles);
            $files->save();
        }
    }

     $currentClient = $files->client;

    return view('admin.dashboard.editFile', compact('currentClient', 'files', 'lawyers', 'courts', 'attributes', 'institutions', 'documentation_offices', 'polices', 'litigation_degrees', 'case_types'));
}




    public function UpdateFiles(Request $request, $files_id)
    {

            $request->validate([
        'caseNum' => 'unique:files,caseNum,' . $files_id,
        'fileCaseNum' => 'unique:files,fileCaseNum,' . $files_id,
    ]);

    $file = File::findOrFail($files_id);
    $file->caseNum = $request->caseNum;
    $file->save();



        $file = file::find($files_id);
        if (!$file)
            return redirect()->back();

        //update data

    $existingPhotos = [];
if (!empty($file->photo)) {
    $existingPhotos = explode('|', $file->photo);  // الصور القديمة لو موجودة
}

$photo = [];

if ($files = $request->file('photo')) {
    foreach ($files as $uploadedFile) {
        $photo_name = md5(rand(1000, 10000));
        $ext = strtolower($uploadedFile->getClientOriginalExtension());
        $photo_full_name = $photo_name . '.' . $ext;
        $upload_path = 'images/casefiles/';
        $photo_url = $upload_path . $photo_full_name;
        $uploadedFile->move($upload_path, $photo_full_name);
        $photo[] = $photo_url;
    }
}

// دمج الصور القديمة مع الجديدة
$allPhotos = array_merge($existingPhotos, $photo);

$file->update([
    'client_id' => $request->client_id,
    'lawyer_id' => $request->lawyer_id,
    'fileCaseNum' => $request->fileCaseNum,
    'attribute_id' => $request->attribute_id,
    'court_id' => $request->court_id,
    'requestingParty' => $request->requestingParty,
    'police_id' => $request->police_id,
    'institution_id' => $request->institution_id,
    'documentation_office_id' => $request->documentation_office_id,
    'caseNum' => $request->caseNum,
    'fileNum' => $request->fileNum,
    'type' => $request->type,
     'year' => $request->year,
    'litigation_degree_id' => $request->litigation_degree_id,
    'photo' => implode('|', $allPhotos),  // هنا تم الدمج
    'opponentName' => $request->opponentName,
    'attorneyType' => $request->attorneyType,
    'opponentAddress' => $request->opponentAddress,
    'professorsLawyer' => $request->professorsLawyer,
    'case_type_id' => $request->case_type_id,
    'proceduresDone' => $request->proceduresDone,
    'procedureDate' => $request->procedureDate,
    'personCharge' => $request->personCharge,
    'details' => $request->details,
]);

        return redirect()->back()->with(['successEdit' => ' تم التحديث بنجاح ']);

    }


public function deleteDoc(Request $request)
{
    $file = urldecode($request->file);  // فك الترميز

    // حماية إضافية - منع حذف أي ملف خارج فولدر معين
    $allowedPath = public_path('images/casefiles');
    $fullPath = realpath(public_path($file));

    if (strpos($fullPath, $allowedPath) !== 0) {
        return back()->with('error', 'طلب حذف غير صالح.');
    }

    if (file_exists($fullPath)) {
        unlink($fullPath);
        return back()->with('success', 'تم حذف الملف بنجاح');
    }

    return back()->with('error', 'الملف غير موجود!');
}




    public function fileDetails($files_id)
    {
        $files = file::find($files_id);
        if (!$files)
            return redirect()->back();

        $files = file::all()->find($files_id);
        $courts  = court ::all();
        $lawyers  = lawyer ::all();
        $sessions  = session ::where('file_id',$files_id)->orderBy('created_at', 'desc')->get();
        $attaches  = attach ::where('file_id',$files_id)->orderBy('created_at', 'desc')->get();
        $documents  = document ::where('file_id',$files_id)->orderBy('created_at', 'desc')->get();
        $bailiffs  = bailiff ::where('file_id',$files_id)->orderBy('created_at', 'desc')->get();
        $experts  = expert ::where('file_id',$files_id)->orderBy('created_at', 'desc')->get();
        $disputes  = dispute ::where('file_id',$files_id)->orderBy('created_at', 'desc')->get();
        $family_disputes  = family_dispute ::where('file_id',$files_id)->orderBy('created_at', 'desc')->get();
        $currentClient = $files->client;

        return view('admin.dashboard.fileDetails', compact('sessions', 'courts', 'lawyers', 'files', 'attaches', 'documents', 'bailiffs', 'currentClient', 'experts', 'disputes', 'family_disputes'));
    }




}
