<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\institutionsRequest;
use Illuminate\Support\Facades\Hash;
use App\Models\institution;
use App\Models\file;
use LaravelLocalization;
use App\Traits\allTraits;


class institutionController extends Controller
{
    use allTraits;



    public function institutionPost(institutionsRequest $request)
    {


        institution::create([
            'name' => $request -> name,
        ]);



        return redirect()->back()->with(['successAdd' => '']);
    }


    public function AllInstitutions() {
        $institutions =  institution::All();
        return view('admin.dashboard.institution', compact('institutions'));
    }


    public function deleteInstitution($institutions_id)
    {

        $institutions = institution::find($institutions_id);

        if (!$institutions)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $institutions->delete();

        return redirect()
            ->route('AllInstitutions')
            ->with(['successDelete' => __('messages.news deleted successfully')]);
    }







    public function editInstitution($institutions_id)
    {

        $institutions = institution::find($institutions_id);  // search in given table id only
        if (!$institutions)
            return redirect()->back();
        $institutions = institution::all()->find($institutions_id);
        return view('admin.dashboard.editInstitution', compact('institutions'));

    }



    public function UpdateInstitution(institutionsRequest $request, $institutions_id)
    {

        $institution = institution::find($institutions_id);
        if (!$institution)
            return redirect()->back();

        //update data


        $institution->update([
            'name' => $request -> name,

        ]);

        return redirect()->back()->with(['successEdit' => ' تم التحديث بنجاح ']);

    }



}
