<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\investsRequest;
use Illuminate\Support\Facades\Hash;
use App\Models\invest;
use LaravelLocalization;
use App\Traits\allTraits;


class investController extends Controller
{
    use allTraits;



    public function investPost(investsRequest $request)
    {


        invest::create([
           'title_ar' => $request -> title_ar,
            'title_en' => $request -> title_en,
            'slug' => preg_replace('/[^\p{Arabic}a-zA-Z0-9\-]+/u', '-', $request->title_ar),
        ]);



        return redirect()->back()->with(['successAdd' => '']);
    }


    public function AllInvests() {
        $invests =  invest::All();
        return view('admin.invests', compact('invests'));
    }


    public function deleteInvest($invests_id)
    {

        $invests = invest::find($invests_id);

        if (!$invests)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $invests->delete();

        return redirect()
            ->route('AllInvests')
            ->with(['successDelete' => __('messages.news deleted successfully')]);
    }







    public function editInvest($invests_id)
    {

        $invests = invest::find($invests_id);  // search in given table id only
        if (!$invests)
            return redirect()->back();
        $invests = invest::all()->find($invests_id);
        return view('admin.editInvest', compact('invests'));

    }



    public function UpdateInvest(investsRequest $request, $invests_id)
    {

        $invest = invest::find($invests_id);
        if (!$invest)
            return redirect()->back();

        //update data


        $invest->update([
            'title_ar' => $request -> title_ar,
            'title_en' => $request -> title_en,

        ]);

        return redirect()->back()->with(['successEdit' => ' تم التحديث بنجاح ']);

    }



}
