<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\lawyerRequest;
use App\Models\lawyer;
use App\Models\specialization;
use LaravelLocalization;
use App\Traits\allTraits;


class lawyerController extends Controller
{
    use allTraits;


    public function lawyerPost(lawyerRequest $request)
    {
        // حفظ الصور
        $file_name = $this->saveImage($request->photo, 'images/lawyer');
        $file_name2 = $this->saveCard($request->idImg, 'images/lawyerCard');

        // إنشاء المحامي وحفظ البيانات الأساسية
        $lawyer = lawyer::create([
            'photo' => $file_name,
            'name_ar' => $request->name_ar,
            'name_en' => $request->name_en,
            'idImg' => $file_name2,
            'phone' => $request->phone,
        ]);

        // ربط التخصصات باستخدام علاقة many-to-many
        if ($request->has('specialization_id')) {
            $lawyer->specializations()->sync($request->specialization_id);
        }

        return redirect()->back()->with(['successAdd' => 'تم إضافة المحامي بنجاح']);
    }



    public function addLawyers() {
        $specializations =  specialization::All();
        return view('admin.dashboard.addLawyers', compact('specializations'));
    }


    public function lawyers() {
        $lawyers =  lawyer::All();
        $specializations =  specialization::All();
        return view('admin.dashboard.lawyers', compact('lawyers', 'specializations'));
    }


    public function deleteLawyers($lawyers_id)
    {

        $lawyers = lawyer::find($lawyers_id);

        if (!$lawyers)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $lawyers->delete();

        return redirect()
            ->route('lawyers')
            ->with(['successDelete' => __('messages.news deleted successfully')]);
    }


    public function editLawyers($lawyers_id)
    {

        $lawyers = lawyer::find($lawyers_id);  // search in given table id only
        if (!$lawyers)
            return redirect()->back();
        $lawyers = lawyer::all()->find($lawyers_id);
        $specializations =  specialization::All();
        return view('admin.dashboard.editLawyers', compact('lawyers', 'specializations'));

    }



    public function UpdateLawyers(lawyerRequest $request, $lawyers_id)
    {

        $lawyer = lawyer::find($lawyers_id);
        if (!$lawyer)
            return redirect()->back();

        //update data

        $file_name = $this->saveImage($request->photo, 'images/lawyer');
        $file_name2 = $this->saveCard($request->idImg, 'images/lawyerCard');

        $lawyer->update([
            'photo' => $file_name,
            'name_ar' => $request -> name_ar,
            'name_en' => $request -> name_en,
            'idImg' => $file_name2,
            'phone' => $request -> phone,
        ]);

            // ربط التخصصات باستخدام علاقة many-to-many
            if ($request->has('specialization_id')) {
                $lawyer->specializations()->sync($request->specialization_id);
            }

        return redirect()->back()->with(['successEdit' => ' تم التحديث بنجاح ']);

    }








}
