<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\litigationDegreeRequest;
use Illuminate\Support\Facades\Hash;
use App\Models\litigation_degree;
use LaravelLocalization;
use App\Traits\allTraits;


class litigationDegreeController extends Controller
{
    use allTraits;



    public function litigationDegreePost(litigationDegreeRequest $request)
    {


        litigation_degree::create([
            'title' => $request -> title,
        ]);



        return redirect()->back()->with(['successAdd' => '']);
    }


    public function AllLitigationDegree() {
        $litigation_degrees =  litigation_degree::All();
        return view('admin.dashboard.litigationDegree', compact('litigation_degrees'));
    }


    public function deleteLitigationDegree($litigation_degrees_id)
    {

        $litigation_degrees = litigation_degree::find($litigation_degrees_id);

        if (!$litigation_degrees)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $litigation_degrees->delete();

        return redirect()
            ->route('AllLitigationDegree')
            ->with(['successDelete' => __('messages.news deleted successfully')]);
    }







    public function editLitigation_degree($litigation_degrees_id)
    {

        $litigation_degrees = litigation_degree::find($litigation_degrees_id);  // search in given table id only
        if (!$litigation_degrees)
            return redirect()->back();
        $litigation_degrees = litigation_degree::all()->find($litigation_degrees_id);
        return view('admin.dashboard.editLitigationDegrees', compact('litigation_degrees'));

    }



    public function UpdateLitigation_degree(litigationDegreeRequest $request, $litigation_degrees_id)
    {

        $litigation_degree = litigation_degree::find($litigation_degrees_id);
        if (!$litigation_degree)
            return redirect()->back();

        //update data


        $litigation_degree->update([
            'title' => $request -> title,

        ]);

        return redirect()->back()->with(['successEdit' => ' تم التحديث بنجاح ']);

    }



}
