<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\PolicesRequest;
use Illuminate\Support\Facades\Hash;
use App\Models\police;
use App\Models\file;
use LaravelLocalization;
use App\Traits\allTraits;


class policeController extends Controller
{
    use allTraits;



    public function policePost(PolicesRequest $request)
    {


        police::create([
            'name' => $request -> name,
            'address' => $request -> address,
        ]);



        return redirect()->back()->with(['successAdd' => '']);
    }


    public function AllPolices() {
        $polices =  police::All();
        return view('admin.dashboard.policeStations', compact('polices'));
    }


    public function deletePolice($polices_id)
    {

        $polices = police::find($polices_id);

        if (!$polices)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $polices->delete();

        return redirect()
            ->route('AllPolices')
            ->with(['successDelete' => __('messages.news deleted successfully')]);
    }







    public function editPolice($polices_id)
    {

        $polices = police::find($polices_id);  // search in given table id only
        if (!$polices)
            return redirect()->back();
        $polices = police::all()->find($polices_id);
        return view('admin.dashboard.editPoliceStations', compact('polices'));

    }



    public function UpdatePolice(PolicesRequest $request, $polices_id)
    {

        $police = police::find($polices_id);
        if (!$police)
            return redirect()->back();

        //update data


        $police->update([
            'name' => $request -> name,
            'address' => $request -> address,

        ]);

        return redirect()->back()->with(['successEdit' => ' تم التحديث بنجاح ']);

    }



}
