<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\post;
use LaravelLocalization;
use App\Traits\allTraits;


class postController extends Controller
{

    use allTraits;

    public function index()
    {
        $posts = Post::whereNull('parent_id')->with('children')->get();
        return view('admin.dashboard.posts', compact('posts'));
    }

    public function create($parent_id = null)
    {
        return view('admin.dashboard.addPosts', compact('parent_id'));
    }

public function store(Request $request)
{
    $request->validate([
        'title' => 'required|string|max:255',
        'content' => 'required|string',
        'attachment' => 'nullable|file|mimes:jpg,jpeg,png,pdf,doc,docx|max:5120', // 5MB max
        'photo' => 'nullable|image|mimes:jpg,jpeg,png|max:5120', // صورة بحد أقصى 5MB
        'parent_id' => 'nullable|exists:posts,id',
    ]);

    $post = new Post();
    $post->title = $request->title;
    $post->content = $request->content;
    $post->parent_id = $request->parent_id;

    // رفع الملفات العامة
    if ($request->hasFile('attachment')) {
        $file = $request->file('attachment');
        $filename = time() . '_' . $file->getClientOriginalName();
        $file->move(public_path('attachments'), $filename);
        $post->attachment = $filename;

    }

    // رفع صورة photo
    if ($request->hasFile('photo')) {
        $photo = $request->file('photo');
        $photoName = time() . '_' . $photo->getClientOriginalName();
        $photo->move(public_path('photos'), $photoName);
        $post->photo = $photoName;
    }

    $post->save();

    return redirect()->back()->with('successAdd', 'تم إضافة المقال الفرعي بنجاح');
}






    public function deletePost($id)
    {
        // ابحث عن المقال الفرعي باستخدام الـ ID
        $Posts = post::findOrFail($id);

        // احذف المقال الفرعي
        $Posts->delete();

        // إعادة التوجيه إلى الصفحة السابقة مع رسالة نجاح
        return redirect()->back()->with('successDelete', 'تم حذف المقال بنجاح');
    }


    public function postsDetails($post_id)
    {
        // جلب المقال الأساسي مع المقالات الفرعية الخاصة به والمقالات الفرعية الخاصة بكل مقال فرعي
        $post = Post::where('id', $post_id)
            ->with('children.children.children') // تحميل المقالات الفرعية الخاصة بكل مقال فرعي، وهكذا
            ->first();

        // التحقق من وجود المقال
        if (!$post) {
            return redirect()->back()->with('error', 'المقال غير موجود');
        }

        // إرسال البيانات إلى الـ View
        return view('admin.dashboard.postsDetails', compact('post'));
    }


    public function storeChild(Request $request)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'content' => 'required|string',
            'attachment' => 'nullable|file|mimes:jpg,jpeg,png,pdf,doc,docx|max:5120', // 5MB max
            'parent_id' => 'required|exists:posts,id',
        ]);

        $post = new Post();
        $post->title = $request->title;
        $post->content = $request->content;
        $post->parent_id = $request->parent_id;

        if ($request->hasFile('attachment')) {
            $file = $request->file('attachment');
            $filename = time() . '_' . $file->getClientOriginalName();
            $file->move(public_path('attachments'), $filename);
            $post->attachment = $filename; // فقط اسم الملف بدون "attachments/"
        }


        $post->save();

        return redirect()->back()->with('successAdd', 'تم إضافة المقال الفرعي بنجاح');
    }


    public function deleteChild($id)
{
    // ابحث عن المقال الفرعي باستخدام الـ ID
    $child = post::findOrFail($id);

    // احذف المقال الفرعي
    $child->delete();

    // إعادة التوجيه إلى الصفحة السابقة مع رسالة نجاح
    return redirect()->back()->with('successDelete', 'تم حذف المقال بنجاح');
}



public function edit($id)
{
    $post = post::findOrFail($id);
    return view('admin.dashboard.editPosts', compact('post'));
}

public function update(Request $request, $id)
{
    $post = post::findOrFail($id);

    $request->validate([
        'title' => 'required|string|max:255',
        'content' => 'required',
        'attachment' => 'nullable|file|mimes:jpg,jpeg,png,pdf,doc,docx',
        'photo' => 'nullable|image|mimes:jpg,jpeg,png|max:5120', // صورة بحد أقصى 5MB
    ]);

    $post->title = $request->title;
    $post->content = $request->content;

    if ($request->hasFile('attachment')) {
        $file = $request->file('attachment');
        $filename = time() . '_' . $file->getClientOriginalName();
        $file->move(public_path('attachments'), $filename);
        $post->attachment = $filename;
    }

      // رفع صورة photo
    if ($request->hasFile('photo')) {
        $photo = $request->file('photo');
        $photoName = time() . '_' . $photo->getClientOriginalName();
        $photo->move(public_path('photos'), $photoName);
        $post->photo = $photoName;
    }

    $post->save();

    return redirect()->back()->with('successEdit', 'تم تحديث المقال بنجاح');
}



}
