<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\specializationsRequest;
use App\Models\specialization;
use LaravelLocalization;
use App\Traits\allTraits;


class specializationsController extends Controller
{
    use allTraits;


    public function specializationPost(specializationsRequest $request)
    {

        specialization::create([
            'title_ar' => $request -> title_ar,
            'title_en' => $request -> title_en,
        ]);

        return redirect()->back()->with(['successAdd' => '']);

    }


    public function specializations() {
        $specializations =  specialization::All();
        return view('admin.dashboard.specializations', compact('specializations'));
    }


    public function deleteSpecializations($specializations_id)
    {

        $specializations = specialization::find($specializations_id);

        if (!$specializations)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $specializations->delete();

        return redirect()
            ->route('specializations')
            ->with(['successDelete' => __('messages.news deleted successfully')]);
    }


    public function editSpecializations($specializations_id)
    {

        // addNews::findOrFail($news_id);
        $specializations = specialization::find($specializations_id);  // search in given table id only
        if (!$specializations)
            return redirect()->back();

        $specializations = specialization::all()->find($specializations_id);
        return view('admin.dashboard.editSpecializations', compact('specializations'));


    }


    public function UpdateSpecializations(specializationsRequest $request, $specializations_id)
    {

        $specialization = specialization::find($specializations_id);
        if (!$specialization)
            return redirect()->back();

        //update data

        $specialization->update([
            'title_ar' => $request -> title_ar,
            'title_en' => $request -> title_en,
        ]);

        return redirect()->back()->with(['successEdit' => ' تم التحديث بنجاح ']);

    }








}
