<?php
namespace App\Http\Controllers\front;
use App\Http\Controllers\Controller;
use App\Models\message;
use Illuminate\Http\Request;

class ChatController extends Controller
{


    /*
    public function getOrCreateConversation(Request $request)
{
    $conversation = Conversation::firstOrCreate(
        [
            'user_id' => $request->user_id,
            'lawyer_id' => $request->lawyer_id,
        ]
    );

    return response()->json($conversation);
}


public function sendMessage(Request $request)
{
    $message = $request->input('message');
    $senderType = $request->input('sender_type');

    // إضافة رسالة المستخدم إلى قاعدة البيانات أو الذاكرة
    $userMessage = [
        'sender_type' => $senderType,
        'message' => $message,
    ];

    // إضافة الرد التلقائي من المحامي
    $lawyerMessage = [
        'sender_type' => 'Lawyer',
        'message' => 'شكراً لتواصلك، سيتم الرد عليك قريباً!',
    ];

    // يمكنك هنا حفظ الرسائل في قاعدة البيانات إذا أردت.

    // إعادة الرسائل إلى الواجهة
    return response()->json([
        'success' => true,
        'messages' => [$userMessage, $lawyerMessage], // إرسال كلا الرسالتين
    ]);
}




public function fetchMessages($conversation_id)
{
    $messages = Message::where('conversation_id', $conversation_id)->get();

    return response()->json($messages);
}

*/

public function sendMessage(Request $request)
{
    // تحقق من أن الرسالة وصيغة المرسل متوافقة
    $request->validate([
        'message' => 'required|string',
        'sender_type' => 'required|string'
    ]);

    // تخزين الرسالة في قاعدة البيانات
    $message = Message::create([
        'sender_type' => $request->sender_type,
        'message' => $request->message,
    ]);

    // إضافة رد المحامي
    $lawyerReply = 'رد المحامي على الرسالة: ' . $message->message;

    return response()->json([
        'success' => true,
        'message' => $message,
        'lawyer_reply' => $lawyerReply
    ]);
}




private function generateLawyerReply($userMessage)
{
    if (stripos($userMessage, 'hello') !== false) {
        return 'مرحباً! كيف يمكنني مساعدتك؟';
    } elseif (stripos($userMessage, 'help') !== false) {
        return 'بالطبع! ما نوع المساعدة التي تحتاجها؟';
    } else {
        return 'شكراً لتواصلك معنا! سنرد عليك قريباً.';
    }
}



public function fetchMessages()
{
    $messages = Message::orderBy('created_at', 'asc')->get();

    return response()->json([
        'success' => true,
        'messages' => $messages
    ]);
}


public function sendReplyPost(Request $request)
{
    $request->validate([
        'message_id' => 'required|exists:messages,id',
        'reply' => 'required|string',
    ]);

    // العثور على الرسالة التي يرد عليها المحامي
    $message = Message::findOrFail($request->message_id);

    // تخزين الرد
    $reply = new Message([
        'sender_type' => 'Lawyer',
        'message' => $request->reply,
    ]);
    $reply->save();

    return response()->json([
        'success' => true,
        'message' => $message,
        'lawyer_reply' => $request->reply
    ]);
}



// في الميثود `sendreply`، جلب الرسائل التي أرسلها المستخدمون.
public function sendreply()
{
    $messages = Message::where('sender_type', 'User')->get();
    return view('front.replayLawyer', compact('messages'));
}









}
