<?php


namespace App\Http\Controllers\front;
use App\Http\Controllers\Controller;
use App\Models\logo;
use App\Models\blog;
use App\Models\comment;
use App\Models\phone;
use App\Models\email;
use App\Models\Address;
use App\Models\service;
use App\Models\post;
use App\Models\invest;
use App\Http\Requests\commentRequest;



use LaravelLocalization;

class blogsController extends Controller
{

    function blogs(){

        $logos =  logo::All();


        $phones =  phone::All();
        $emails =  email::All();
        $addresses =  address::select('id',
        'title_' . LaravelLocalization::getCurrentLocale() . ' as title', ) -> get();


        $invests =  invest::select('id',
         'slug',
        'title_' . LaravelLocalization::getCurrentLocale() . ' as title') -> get();

        $services =  service::select('id',
        'slug',
        'title_' . LaravelLocalization::getCurrentLocale() . ' as title',) -> get();
        $allServices = $services;
        $posts = post::where('parent_id', null)->latest()->take(6)->get();

        return view('front.blogs', compact('logos', 'allServices', 'invests', 'services',  'posts',  'phones', 'emails', 'addresses'));
    }





    public function blogDetails($id)
    {

        // جلب بيانات البرنامج
        $posts = post::with('children')->findOrFail($id);




        // $comments = $blogs->comments;
        $logos =  logo::All();

        $phones =  phone::All();
        $emails =  email::All();


        $invests =  invest::select('id',
         'slug',
        'title_' . LaravelLocalization::getCurrentLocale() . ' as title') -> get();

         $services =  service::select('id',
        'slug',
        'title_' . LaravelLocalization::getCurrentLocale() . ' as title',) -> get();
        $allServices = $services;
        $addresses =  address::select('id',
        'title_' . LaravelLocalization::getCurrentLocale() . ' as title', ) -> get();

        return view('front.blogDetails', compact('logos', 'posts', 'invests', 'allServices', 'services',  'phones', 'emails', 'addresses'));

    }




    public function commentPost(commentRequest $request, $blog_id)
    {
        comment::create([
            'name' => $request->name,
            'comment' => $request->comment,
            'blog_id' => $blog_id,
        ]);

        return redirect()->back()->with(['successSendComment' => 'تم إضافة التعليق بنجاح']);
    }



}
