<?php


namespace App\Http\Controllers\front;
use App\Http\Controllers\Controller;
use App\Models\logo;
use App\Models\caseModel;
use App\Models\phone;
use App\Models\email;
use App\Models\Address;
use App\Models\service;
use App\Models\invest;

use LaravelLocalization;

class servicesController extends Controller
{

    function services(){

        $logos =  logo::All();
        $cases_s =  caseModel::select('id',
        'title_' . LaravelLocalization::getCurrentLocale() . ' as title',
        'photo',
        'details_' . LaravelLocalization::getCurrentLocale() . ' as details') -> get();

        $phones =  phone::All();
        $emails =  email::All();
        $addresses =  address::select('id',
        'title_' . LaravelLocalization::getCurrentLocale() . ' as title', ) -> get();


        $invests =  invest::select('id',
         'slug',
        'title_' . LaravelLocalization::getCurrentLocale() . ' as title') -> get();

        $services =  service::select('id',
        'slug',
        'photo',
        'title_' . LaravelLocalization::getCurrentLocale() . ' as title',) -> get();
         $allServices = $services;

        return view('front.services', compact('logos', 'allServices', 'invests', 'cases_s', 'services', 'phones', 'emails', 'addresses'));
    }



public function servicesDetails($slug)
{
    $service = service::select(
        'id',
        'title_' . LaravelLocalization::getCurrentLocale() . ' as title',
        'photo',
        'details_' . LaravelLocalization::getCurrentLocale() . ' as details',
        'slug'
    )->where('slug', $slug)->first();

    if (!$service) {
        return redirect()->back();
    }

    $allServices = service::select(
        'id',
        'title_' . LaravelLocalization::getCurrentLocale() . ' as title',
        'slug',
    )->get();


        $invests =  invest::select('id',
         'slug',
        'title_' . LaravelLocalization::getCurrentLocale() . ' as title') -> get();

    $logos = logo::all();
    $phones = phone::all();
    $emails = email::all();

        $addresses =  address:: get();

    return view('front.servicesDetails', compact(
        'service',
        'allServices',
        'logos',
        'phones',
        'emails',
        'addresses',
        'invests'
    ));
}






}
