<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class userRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'email' => 'required | email | unique:admins'.$this->id,
            'password' => 'required|min:6',

        ];
    }

    public function messages()
    {
        return [
            'email.required' => 'البريد الالكترونى مطلوب',
            'email.unique' => 'البريد الالكترونى موجود',
            'email.email' => 'يجب أن يكون البريد الإلكتروني عنوان بريد إلكتروني صالحًا',
            'password.required' => 'كلمة المرور مطلوبة',
            'password.min:6' => 'يجب أن تتكون كلمة المرور من 6 أحرف على الأقل',
        ];
    }
}
