<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Message extends Model
{
    // protected $fillable = ['conversation_id', 'sender_type', 'message'];

    // public function conversation()
    // {
    //     return $this->belongsTo(Conversation::class);
    // }



      // تحديد اسم الجدول إذا كان مختلفاً عن القاعدة الافتراضية
      protected $table = 'messages';

      // تحديد الأعمدة القابلة للتعبئة (mass assignable)
      protected $fillable = [
          'sender_type', // نوع المرسل (User أو Lawyer)
          'message',     // نص الرسالة
      ];

      // تحديد الحقول التي سيتم إخفاؤها عند تحويل النموذج إلى JSON
      protected $hidden = [
          'updated_at', // إخفاء وقت التعديل إذا لم يكن ضروريًا
      ];


      public function reply()
{
    return $this->hasOne(Message::class, 'parent_id');
}

public function parentMessage()
{
    return $this->belongsTo(Message::class, 'parent_id');
}
}

