<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Permission\Traits\HasRoles;


class Admin extends Authenticatable
{

    use Notifiable;
    use HasFactory, HasRoles;


    protected $guard_name = 'admin'; // تحديد الحارس الافتراضي
    protected $fillable = [
        'email', 'getRoleNames', 'password', 'status',
    ];

    protected $hidden = [
        'password', 'remember_token',
    ];


    public function files()
    {
        return $this->belongsToMany(file::class, 'user_cases', 'admin_id', 'file_id');
    }
}
