<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\SoftDeletes;

class client extends Authenticatable
{
    use SoftDeletes;

    protected $table = "clients";
    protected $fillable = ['name', 'code', 'password', 'address', 'phone', 'created_at', 'updated_at'];

    protected $dates = ['deleted_at'];

    protected $hidden = [
        'password', 'remember_token',
    ];


    public function files()
    {
        return $this->hasMany('App\Models\file', 'client_id', 'id');
    }

    public function latestIncome()
    {
        return $this->hasOne(clientIncome::class, 'client_id')->latest('id');
    }


    public function clientIncomes()
    {
        return $this->hasMany(clientIncome::class, 'client_id');
    }



}
