<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\SoftDeletes;

class company extends Model
{
    use SoftDeletes;

    protected $table = "companies";
    protected $fillable = ['name', 'code', 'password', 'address', 'phone', 'created_at', 'updated_at'];

    protected $dates = ['deleted_at'];

    protected $hidden = [
        'password', 'remember_token',
    ];


    public function files()
    {
        return $this->hasMany('App\Models\file', 'company_id', 'id');
    }


}
