<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class file extends Model
{

    use SoftDeletes;
    protected $table = "files";
    protected $fillable = ['client_id', 'lawyer_id', 'fileCaseNum', 'company_id', 'attribute_id', 'type', 'litigation_degree_id', 'case_type_id', 'institution_id', 'requestingParty', 'fileNum',  'court_id', 'documentation_office_id', 'police_id', 'attorneyType', 'caseNum', 'year', 'photo', 'litigationDegree', 'caseType', 'opponentName', 'opponentAddress', 'professorsLawyer', 'details', 'proceduresDone', 'procedureDate', 'personCharge', 'created_at', 'updated_at'];
    protected $hidden = ['created_at, updated_at'];





    public function police()
    {
        return $this->belongsTo('App\Models\police', 'police_id');
    }

    public function lawyer()
    {
        return $this->belongsTo('App\Models\lawyer', 'lawyer_id');
    }

    public function institution()
    {
        return $this->belongsTo('App\Models\institution', 'institution_id');
    }

    public function documentation_office()
    {
        return $this->belongsTo('App\Models\documentation_office', 'documentation_office_id');
    }

  public function client()
    {
        return $this->belongsTo(client::class);
    }




    public function court()
    {
        return $this->belongsTo('App\Models\court', 'court_id');
    }

    public function attributes()
    {
        return $this->belongsTo('App\Models\attribute', 'attribute_id');
    }


    public function litigation_degrees()
    {
        return $this->belongsTo('App\Models\litigation_degree', 'litigation_degree_id');
    }


    public function case_types()
    {
        return $this->belongsTo('App\Models\case_type', 'case_type_id');
    }


    public function attaches()
    {
        return $this->hasMany('App\Models\attach', 'file_id', 'id');
    }


      // العلاقة مع الجلسات
      public function sessions()
      {
          return $this->hasMany('App\Models\session', 'file_id', 'id');
      }

      // العلاقة مع المستندات
      public function documents()
      {
          return $this->hasMany('App\Models\document', 'file_id', 'id');
      }

    // العلاقة مع المحضريين
    public function bailiffs()
    {
        return $this->hasMany('App\Models\bailiff', 'file_id', 'id');
    }

    // العلاقة مع الخبراء
    public function experts()
    {
        return $this->hasMany('App\Models\expert', 'file_id', 'id');
    }


    // العلاقة مع فض المناعات
    public function disputes()
    {
        return $this->hasMany('App\Models\dispute', 'file_id', 'id');
    }


    // العلاقة مع منازعات الاسرة
    public function family_disputes()
    {
        return $this->hasMany('App\Models\family_dispute', 'file_id', 'id');
    }

    public function admins()
    {
        return $this->belongsToMany(admin::class, 'user_cases', 'file_id', 'admin_id');
    }



    public function incomes()
    {
        return $this->hasMany(clientIncome::class, 'file_id');
    }

}
