<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;

class lawyer extends Model
{

    use Notifiable;
    protected $table = "lawyers";
    protected $fillable = ['photo', 'name_ar', 'name_en', 'specialization_id', 'idImg', 'phone', 'created_at', 'updated_at'];
    protected $hidden = ['created_at, updated_at'];


    public function specializations()
    {
        return $this->belongsToMany(specialization::class, 'lawyer_specialization', 'lawyer_id', 'specialization_id');
    }




}


