<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFilesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('files', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('client_id');
            $table->foreign('client_id')->references('id')->on('clients')->onDelete('cascade');

            $table->unsignedBigInteger('attribute_id');
            $table->foreign('attribute_id')->references('id')->on('attributes')->onDelete('cascade');

            $table->unsignedBigInteger('court_id');
            $table->foreign('court_id')->references('id')->on('courts');

            $table->unsignedBigInteger('documentation_office_id');
            $table->foreign('documentation_office_id')->references('id')->on('documentation_offices');

            $table->unsignedBigInteger('police_id');
            $table->foreign('police_id')->references('id')->on('polices');

            $table->unsignedBigInteger('litigation_degree_id');
            $table->foreign('litigation_degree_id')->references('id')->on('litigation_degrees');

            $table->unsignedBigInteger('case_type_id');
            $table->foreign('case_type_id')->references('id')->on('case_types');

            $table->unsignedBigInteger('institution_id');
            $table->foreign('institution_id')->references('id')->on('institutions');

            $table->unsignedBigInteger('lawyer_id');
            $table->foreign('lawyer_id')->references('id')->on('lawyers');

            $table->string('proceduresDone');
            $table->string('procedureDate');
            $table->string('personCharge');
            $table->string('fileCaseNum');

            $table->string('requestingParty');
            $table->string('caseNum');
            $table->string('type');
            $table->string('year');
            $table->string('fileNum');
            $table->string('litigationDegree');
            $table->string('caseType');
            $table->string('attorneyType');
            $table->LONGTEXT('photo');
            $table->string('opponentName');
            $table->string('opponentAddress')->nullable();;
            $table->string('professorsLawyer');
            $table->LONGTEXT('details');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('files');
    }
}

